<!------------------------------------------------------------------------------->
<!-----------------------------COPIA AI BRXO------------------------------------->
<!-----------------------DEVELOPER: EMANUEL NASCIMENTO--------------------------->
<!--------------------CONTATO: https://t.me/ebjnasciment------------------------->
<!------------------------------------------------------------------------------->


<?php
$uploadsDir = 'uploads'; // Pasta onde os JSONs estão armazenados
$jsonFiles = glob("$uploadsDir/*.json"); // Obtém todos os arquivos JSON
$apps = [];

foreach ($jsonFiles as $file) {
    $jsonContent = file_get_contents($file);
    $data = json_decode($jsonContent, true);
    if ($data) {
        $apps[] = $data;
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Loja de Apps</title>
    <style>
        body {
    background: url("https://wallpapers.com/images/hd/1920x1080-black-oouxzf7yjjap4fwj.jpg") no-repeat center center fixed;
    background-size: cover; /* A imagem vai cobrir toda a tela */
    color: white;
    font-family: Arial, sans-serif;
    text-align: center;
    height: 100vh; /* Garantir que a altura da tela seja 100% */
    margin: 0; /* Remover margens padrão do body */
}


        .container {
            width: 90%;
            max-width: 1200px;
            margin: 20px auto;
        }

        .grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 60px;
            justify-content: center;
        }

        .card-container {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .card {
            background-color: #050505;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 6px 12px rgba(255, 255, 255, 0.3);
            display: flex;
            flex-direction: column;
            height: 350px;
            width: 100%;
            max-width: 280px;
            margin: 0 auto;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: 3px solid white;
            cursor: pointer;
            outline: none;
        }

        .card img {
            width: 100%;
            height: 55%;
            object-fit: cover;
            display: none;
        }

        .card img.active {
            display: block;
        }

        .card-content {
            padding: 12px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            height: 45%;
        }

        .card h2 {
            font-size: 20px;
            margin: 0;
        }

        .card p {
            font-size: 14px;
            margin-bottom: 8px;
        }

        .btn-download {
            display: block;
            background-color: #007bff;
            color: white;
            padding: 10px;
            text-decoration: none;
            border-radius: 8px;
            font-weight: bold;
            width: 100%;
            max-width: 280px;
            margin: 10px auto 0 auto;
            box-sizing: border-box;
            text-align: center;
            transition: box-shadow 0.3s ease, border 0.3s ease;
        }

        .card:hover {
            transform: scale(1.05);
            box-shadow: 0 10px 20px rgba(255, 255, 255, 0.5);
        }

        .card:focus {
            transform: scale(1.05);
            box-shadow: 0 12px 24px rgba(255, 255, 255, 0.7);
            border: 4px solid yellow;
        }

        .btn-download:focus {
            border: 4px solid yellow;
            box-shadow: 0 12px 24px rgba(255, 255, 255, 0.7);
        }

        @media (max-width: 1024px) {
            .grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 768px) {
            .grid {
                grid-template-columns: repeat(1, 1fr);
            }
        }

        /* Título piscando */
        @keyframes piscar {
            0% { color: white; }
            50% { color: transparent; }
            100% { color: white; }
        }

        h1 {
            font-size: 42px;
            animation: piscar 1s infinite;
            margin-bottom: 90px;
        }
    </style>
</head>
<body>
     <div class="container">
        <h1>Loja de Apps</h1>
        <div class="grid">
            <?php foreach ($apps as $app): ?>
                <div class="card-container">
                    <div class="card" tabindex="0">
                        <!-- Carrossel de Imagens -->
                        <?php if (!empty($app['logo'])): ?>
                            <?php foreach ($app['logo'] as $index => $logo): ?>
                                <img src="<?= $basePath . 'uploads/' . basename($logo) ?>" alt="Logo do App" class="<?= $index === 0 ? 'active' : '' ?>" id="img-<?= $index ?>">
                            <?php endforeach; ?>
                        <?php endif; ?>
                        
                        <div class="card-content">
                            <h2><?= htmlspecialchars($app['nome']) ?></h2>
                            <p><?= htmlspecialchars($app['descricao']) ?></p>
                        </div>
                    </div>
                    <a href="<?= $basePath . htmlspecialchars($app['arquivo']) ?>" class="btn-download">Baixar App</a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>


    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let cards = document.querySelectorAll(".card");
            
            cards.forEach(card => {
                let images = card.querySelectorAll("img");
                let currentImageIndex = 0;

                function changeImage() {
                    images[currentImageIndex].classList.remove("active");
                    currentImageIndex = (currentImageIndex + 1) % images.length;
                    images[currentImageIndex].classList.add("active");
                }

                if (images.length > 1) {
                    setInterval(changeImage, 2000); // Mudar de imagem a cada 2 segundos
                }
            });

            let currentIndex = 0;
            if (cards.length > 0) {
                cards[currentIndex].focus();
            }

            document.addEventListener("keydown", function(event) {
                if (event.key === "ArrowRight") {
                    currentIndex = (currentIndex + 1) % cards.length;
                } else if (event.key === "ArrowLeft") {
                    currentIndex = (currentIndex - 1 + cards.length) % cards.length;
                } else if (event.key === "Enter") {
                    let downloadBtn = cards[currentIndex].parentElement.querySelector(".btn-download");
                    if (downloadBtn) downloadBtn.click();
                }
                cards[currentIndex].focus();
            });
        });
    </script>
</body>
</html>
