<!------------------------------------------------------------------------------->
<!-----------------------------COPIA AI BRXO------------------------------------->
<!-----------------------DEVELOPER: EMANUEL NASCIMENTO--------------------------->
<!--------------------CONTATO: https://t.me/ebjnasciment------------------------->
<!------------------------------------------------------------------------------->


<?php
session_start();

// Caminho do banco de dados SQLite
$db_path = realpath(__DIR__ . '/api/db.db');

// Verifica se o banco de dados existe
if (!file_exists($db_path)) {
    die("Erro: Banco de dados não encontrado.");
}

// Conexão com o banco de dados
try {
    $db = new PDO("sqlite:$db_path");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro ao conectar ao banco de dados: " . $e->getMessage());
}

// Verificar se o usuário já está logado
if (isset($_SESSION['logado']) && $_SESSION['logado'] === true) {
    header('Location: cadastro.php');
    exit;
}

// Verificar se o formulário de login foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario = $_POST['usuario'];
    $senha = $_POST['senha'];

    // Consulta no banco de dados
    $query = $db->prepare("SELECT senha FROM usuarios WHERE usuario = :usuario");
    $query->bindValue(':usuario', $usuario, PDO::PARAM_STR);
    $query->execute();
    $row = $query->fetch(PDO::FETCH_ASSOC);

    // Verifica se encontrou o usuário e se a senha está correta
    if ($row && password_verify($senha, $row['senha'])) {
        $_SESSION['logado'] = true;
        $_SESSION['usuario'] = $usuario;
        header('Location: cadastro.php');
        exit;
    } else {
        $erro = "Usuário ou senha incorretos!";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link rel="stylesheet" href="style.css">
</head>
<style>
body {
    margin: 0;
    padding: 0;
    font-family: Arial, sans-serif;
    background-color: #111; /* Fundo escuro */
    height: 100vh;
    display: flex;
    justify-content: center;
    align-items: center;
    color: #fff;
}

.container {
    background: rgba(0, 0, 0, 0.7); /* Fundo preto semi-transparente */
    padding: 40px;
    border-radius: 10px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.5);
    text-align: center;
    max-width: 400px;
    width: 100%;
    border-radius: 12px; /* Bordas arredondadas */
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.4), 0 0 20px 5px rgba(255, 255, 255, 0.6); /* Efeito 3D com bordas brancas */
    border: 2px solid white; /* Borda branca no estilo 3D */
}



.logo img {
    width: 120px;
    margin-bottom: 10px;
    border: 1px white solid;
}

h1 {
    margin-bottom: 20px;
    font-size: 26px;
    color: #fff;
    font-weight: 600;
}

.input-group {
    margin-bottom: 20px;
    text-align: left;
}

.input-group label {
    display: block;
    margin-bottom: 5px;
    font-weight: bold;
    color: #ddd;
}

.input-group input {
    width: 100%;
    padding: 12px;
    border: 1px solid #444;
    border-radius: 5px;
    background-color: #222;
    color: #fff;
    font-size: 16px;
    box-sizing: border-box; /* Garante que o padding seja levado em conta na largura */
}

button {
    width: 100%;
    padding: 12px;
    background-color: green;
    color: white;
    border: 2px white solid;
    border-radius: 5px;
    font-size: 16px;
    cursor: pointer;
    margin-bottom: 30px; 
}

button:hover {
    background-color: #0056b3;
}

.erro {
    color: red;
    margin-bottom: 20px;
}

</style>
<body>
    <div class="container">
        <div class="logo">
            <img src="./img/logo2.png" alt="Logo">
        </div>
        <h1>PAINEL ADM</h1>
        <?php if (isset($erro)): ?>
            <p class="erro"><?php echo $erro; ?></p>
        <?php endif; ?>
        <form method="POST">
            <div class="input-group">
                <label for="usuario">Usuário</label>
                <input type="text" id="usuario" name="usuario" required>
            </div>
            <div class="input-group">
                <label for="senha">Senha</label>
                <input type="password" id="senha" name="senha" required>
            </div>
            <button type="submit">Entrar</button>
        </form>
    </div>
</body>
<?php include './includes/footer.php';?>
</html>
